% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_arima.R
\name{ts_arima}
\alias{ts_arima}
\title{ARIMA}
\usage{
ts_arima()
}
\value{
a \code{ts_arima} object.
}
\description{
Creates a time series prediction object that
uses the AutoRegressive Integrated Moving Average (ARIMA).
It wraps the forecast library.
}
\examples{
data(sin_data)
ts <- ts_data(sin_data$y, 0)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_arima()
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
