% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_nb.R
\name{cla_nb}
\alias{cla_nb}
\title{Naive Bayes Classifier}
\usage{
cla_nb(attribute, slevels)
}
\arguments{
\item{attribute}{attribute target to model building.}

\item{slevels}{possible values for the target classification.}
}
\value{
returns a classification object.
}
\description{
Classification using the Naive Bayes algorithm
It wraps the e1071 library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_nb("Species", slevels)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
