% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skcla_knn.R
\name{skcla_knn}
\alias{skcla_knn}
\title{K-Nearest Neighbors Classifier}
\usage{
skcla_knn(
  attribute,
  slevels,
  n_neighbors = 5,
  weights = "uniform",
  algorithm = "auto",
  leaf_size = 30,
  p = 2,
  metric = "minkowski",
  metric_params = NULL,
  n_jobs = NULL
)
}
\arguments{
\item{attribute}{Target attribute name for model building}

\item{slevels}{List of possible values for classification target}

\item{n_neighbors}{Number of neighbors to use for queries}

\item{weights}{Weight function used in prediction ('uniform', 'distance')}

\item{algorithm}{Algorithm used to compute nearest neighbors ('auto', 'ball_tree', 'kd_tree', 'brute')}

\item{leaf_size}{Leaf size passed to BallTree or KDTree}

\item{p}{Power parameter for the Minkowski metric}

\item{metric}{Distance metric for the tree ('euclidean', 'manhattan', 'chebyshev', 'minkowski', etc.)}

\item{metric_params}{Additional parameters for the metric function}

\item{n_jobs}{Number of parallel jobs for neighbor searches}
}
\value{
A K-Nearest Neighbors classifier object

\code{skcla_knn} object
}
\description{
Implements classification using the K-Nearest Neighbors algorithm.
This function wraps the KNeighborsClassifier from Python's scikit-learn library.
}
\details{
K-Nearest Neighbors Classifier
}
\examples{
#See an example of using `skcla_knn` at this
#https://github.com/cefet-rj-dal/daltoolboxdp/blob/main/examples/skcla_knn.md
}
