% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_psa_samp.R
\name{gamma_params}
\alias{gamma_params}
\title{Calculate shape and scale (or rate) parameters of a gamma distribution.}
\usage{
gamma_params(mu, sigma, scale = TRUE)
}
\arguments{
\item{mu}{scalar with the mean of the random variable.}

\item{sigma}{scalar with the standard deviation of the random variable.}

\item{scale}{logical variable indicating scale parameterization of the gamma distribution
(Default is TRUE). If FALSE, rate parameterization is retrieved}
}
\value{
A list contianing the following:

shape Shape parameter of gamma distribution

scale Scale parameter of gamma distribution (If scale=TRUE)

rate Rate parameter of gamma distribution (If scale=FALSE)
}
\description{
Function to calculate the shape, \eqn{\alpha}, and scale, \eqn{\theta}, (or rate, \eqn{\beta})
parameters of a gamma distribution based on the method of moments (MoM)
using the mean \eqn{\mu} and standard deviation \eqn{\sigma} of the random
variable of interest.
}
\section{Details}{

Based on method of moments. If \eqn{\mu} is the mean and
\eqn{\sigma} is the standard deviation of the random variable, then the
the shape, \eqn{\alpha}, scale, \eqn{\theta}, and rate, \eqn{\beta}, parameters are computed
as follows
\deqn{\alpha=\frac{\mu^2}{\sigma^2},}
\deqn{\theta = \frac{\sigma^2}{\mu}}
and
\deqn{\beta = \frac{\mu}{\sigma^2}}
}

\examples{
mu    <- 2
sigma <- 1
# Scale specification
gamma_params(mu, sigma)
# Rate specification
gamma_params(mu, sigma, scale = FALSE)
}
\references{
\itemize{
\item Gamma distribution. (2018, February 7). In Wikipedia, The Free
Encyclopedia. Retrieved 17:23, February 11, 2018,
from https://en.wikipedia.org/w/index.php?title=Gamma_distribution&oldid=824541785
}
}
\keyword{distribution;}
\keyword{gamma}
\keyword{method}
\keyword{moments}
\keyword{of}
