% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_related_activities.R
\name{detect_related_activities}
\alias{detect_related_activities}
\title{Detect missing related activities}
\usage{
detect_related_activities(
  activitylog,
  antecedent,
  consequent,
  details,
  filter_condition
)
}
\arguments{
\item{activitylog}{The activity log}

\item{antecedent}{Activity name of the activity that acts as a an antecedent (if antecedent occurs, then consequent should also occur)}

\item{consequent}{Activity name of the activity that acts as a an consequent (if antecedent occurs, then consequent should also occur)}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
Numeric vector containing the case identifiers of cases for which related activities are not present
}
\description{
Function detecting missing related activity registration, i.e. detecting activities that should be registered for a case because another activity is registered for that case
}
\examples{
\donttest{
data("hospital_actlog")
detect_related_activities(activitylog = hospital_actlog,
     antecedent = "Treatment evaluation",
     consequent = "Treatment")
}
}
