% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbm.Learn.R
\name{trainRBM}
\alias{trainRBM}
\title{Trains an \code{\linkS4class{RBM}} with contrastive divergence}
\usage{
trainRBM(rbm, trainData, numEpochs = 1, numCD = 1, shuffleTrainData = T,
  ...)
}
\arguments{
\item{rbm}{A instance of the class \code{\linkS4class{RBM}}.}

\item{trainData}{The data matrix for the training}

\item{numEpochs}{The number of training iterations}

\item{numCD}{Number of contrastive divergence iterations}

\item{shuffleTrainData}{Whether to shuffle the training data prior to each
epoch.}

\item{...}{Additional parameters for the unit functions}
}
\description{
The function trains a restricted Boltzmann machine (\code{\linkS4class{RBM}}) with 
the contrastive divergence method.
}
\details{
This function is build on the basis of the code from G. Hinton et. 
  al. (http://www.cs.toronto.edu/~hinton/MatlabForSciencePaper.html - last 
  visit 2016-04-30) for the pre training of deep belief nets. The original 
  code is located in the files 'rbm.m' and 'rbmhidlinear.m'. It iterates in 
  every epoche over the batches and calculates the updates for the weights. 
  If it is the first CD iteration or the CD iterations are finished, the 
  hidden units are calculated with the real value activations of the visible 
  units, otherwise with the binary activations. To tell the unit functions 
  the actual state of the training, the function generates a array with the 
  following running parameters and passes them to the units: Number of 
  epochs: "numEpochs", current epochs: "currentEpoch", Number of batches: 
  "numBatches", current batch: "currentBatch", Maximal CD iterations: 
  "numCD", current CD iteration: "currentCD", CD is finished: "finishCD".
}
\seealso{
\code{\linkS4class{RBM}}
}
\keyword{internal}

