% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2BayesAss.r
\name{gl2bayesAss}
\alias{gl2bayesAss}
\title{Converts a genlight object into bayesAss (BA3) input format}
\usage{
gl2bayesAss(
  x,
  ploidy = 2,
  outfile = "gl.BayesAss.txt",
  outpath = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{ploidy}{Set the ploidy [defaults 2].}

\item{outfile}{File name of the output file [default 'gl.BayesAss.txt'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns the input file as data.table
}
\description{
This function exports a genlight object into bayesAss format and save it into a
file.
This function only caters for \code{ploidy=2}.
}
\examples{
require("dartR.data")
#only the first 100 due to check time
gl2bayesAss(platypus.gl[,1:100], outpath=tempdir())
}
\references{
Mussmann S. M., Douglas M. R., Chafin T. K. and Douglas M. E. (2019) BA3-SNPs: 
Contemporary migration reconfigured in BayesAss for next-generation sequence data. 
Methods in Ecology and Evolution 10, 1808-1813.

Wilson G. A. and Rannala B. (2003) Bayesian Inference of Recent Migration Rates 
Using Multilocus Genotypes. Genetics 163, 1177-1191.
}
\seealso{
Other linker: 
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Carlo Pacioni (Post to
 \url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
