% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.allna.r
\name{gl.report.allna}
\alias{gl.report.allna}
\title{Reports loci that are all NA across individuals and/or populations
with all NA across loci}
\usage{
gl.report.allna(x, by.pop = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the input genlight object [required].}

\item{by.pop}{If TRUE, loci that are all missing in any one population
are reported [default FALSE]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
gl.report.allna
}
\description{
This script reports loci or individuals with all calls missing (NA),
 from a genlight object.

A DArT dataset will not have loci for which the calls are scored all as
missing (NA) for a particular individual, but such loci can arise rarely when
 populations or individuals are deleted. Similarly, a DArT dataset will not
 have individuals for which the calls are scored all as missing (NA) across
 all loci, but such individuals may sneak in to the dataset when loci are
 deleted. Retaining individual or loci with all NAs can cause issues for
 several functions.

 Also, on occasions an analysis will require that there are some loci scored
 in each population. Setting by.pop=TRUE will result in removal of loci when
 they are all missing in any one population.

Note that loci that are missing for all individuals in a population are
not imputed with method 'frequency' or 'HW'. Consider
using the function \code{\link{gl.filter.allna}} with by.pop=TRUE.
}
\examples{
# SNP data
  result <- gl.report.allna(testset.gl, verbose=3)
# Tag P/A data
  result <- gl.report.allna(testset.gs, verbose=3)
}
\seealso{
Other matched report: 
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}

Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.hwe}()}
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
\concept{matched report}
