% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.factorloadings.r
\name{gl.report.factorloadings}
\alias{gl.report.factorloadings}
\title{Reports factor loadings for a PCA or PCoA}
\usage{
gl.report.factorloadings(
  pca,
  axis = 1,
  n.display = 15,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  bins = 25,
  verbose = NULL,
  ...
)
}
\arguments{
\item{pca}{Name of the glPCA object containing factor loadings [required].}

\item{axis}{Axis in the ordination used to display the factor loadings [default 1]}

\item{n.display}{Number of loci for which to display factorloadings [default 15]}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}

\item{...}{Parameters passed to function \link[ggplot2]{ggsave}, 
such as width and height, when the ggplot is to be saved.}
}
\value{
The unchanged genlight object
}
\description{
Extracts the factor loadings from a glPCA object (generated by gl.pcoa) and plots
their distribuion.
}
\details{
The function extracts the factor loadings for a given axis from a PCA object 
generated by gl.pcoa and plots their magnitudes. Useful for identifying loci
that load high for a given axis. 

 A color vector can be obtained with gl.select.colors() and then passed to the function
 with the plot.colors parameter.
 
Themes can be obtained from in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
  If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.
 If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir().
}
\examples{
pca <- gl.pcoa(testset.gl)
gl.report.factorloadings(pca = pca)

}
\seealso{
Other matched reports: 
\code{\link{gl.mahal.assign}()},
\code{\link{gl.report.bases}()},
\code{\link{gl.report.fstat}()},
\code{\link{gl.report.monomorphs}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched reports}
