% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.collapse.matrix.r
\name{utils.collapse.matrix}
\alias{utils.collapse.matrix}
\title{Collapses a distance matrix calculated for individuals to a distance matrix for populations defined in a dartR
genlight object}
\usage{
utils.collapse.matrix(D, x, verbose = NULL)
}
\arguments{
\item{D}{Name of the matrix containing the distances between individuals [required].}

\item{x}{Name of the genlight object containing the genotypes [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
 progress log; 3, progress and results summary; 5, full report [default 2].
 
 @details
This script takes a matrix of distances calculated between individuals and collapses it by averaging to a matrix of distances between populations.
The script gl.dist.ind has a lot of options for distances for presence absence data, but gl.dist.pop does not. This script allows efficient and
consistent transfer of this capability to gl.dist.pop.}
}
\value{
An object of class 'dist' or 'matrix' giving distances between individuals
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()},
\code{\link{utils.vcfr2genlight.polyploid}()}
}
\author{
Author: Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{utilities}
