% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.jackknife.R
\name{utils.jackknife}
\alias{utils.jackknife}
\title{An internal function to conducts jackknife resampling using a genlight object}
\usage{
utils.jackknife(
  x,
  FUN,
  unit = "loc",
  recalc = FALSE,
  mono.rm = FALSE,
  n.cores = 1,
  verbose = NULL,
  ...
)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{FUN}{the name of the function to be used to calculate the statistic}

\item{unit}{The unit to use for resampling. One of c("loc", "ind", "pop"): 
loci, individuals or populations}

\item{recalc}{If TRUE, recalculate the locus metadata statistics [default FALSE].}

\item{mono.rm}{If TRUE, remove monomorphic and all NA loci [default FALSE].}

\item{n.cores}{The number of cores to use. If "auto", it will 
use all but one available cores.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress but not results; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}

\item{...}{any additional arguments to be passed to FUN}
}
\value{
A list of length n where each element is the output of FUN
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
Jackknife resampling is a statistical procedure where for a dataset of sample 
size n, subsamples of size n-1 are used to compute a statistic. The collection 
of the values obtained can be used to evaluate the variability around the point 
estimate. This function can take the loci, the individuals or the populations 
as units over which to conduct resampling.
Note: when n is very small, jackknife resampling is not recommended.
Parallel computation is implemented. The argument  \code{n.cores} indicates the 
number of core to use. If "auto", it will use all but one available 
cores. If the number of units is small (e.g. a few populations), there is not 
real advantage in using parallel computation. On the other hand, if the number 
of units is large (e.g. thousands of loci), even with parallel computation, 
this function can be very slow.
}
\examples{
require("dartR.data")
platMod.gl <- gl.filter.allna(platypus.gl) 
chk.pop <- utils.jackknife(x=platMod.gl, FUN="gl.alf", unit="pop", 
recalc = FALSE, mono.rm = FALSE, n.cores = 1, verbose=0)
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.collapse.matrix}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()},
\code{\link{utils.vcfr2genlight.polyploid}()}
}
\author{
Custodian: Carlo Pacioni -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{utilities}
