% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.recursive.r
\name{gl.collapse.recursive}
\alias{gl.collapse.recursive}
\title{Recursively collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse.recursive(gl, prefix = "collapse", threshold = 0)
}
\arguments{
\item{gl}{-- name of the genlight object from which the distance matricies are to be calculated [required]}

\item{prefix}{-- a string to be used as a prefix in generating the matricies of fixed differences (stored to disk) and the recode
tables (also stored to disk) [default "collapse"]}

\item{threshold}{-- the threshold distance value for amalgamating populations [default 0]}
}
\value{
The new genlight object with recoded populations.
}
\description{
This script generates a fixed difference matrix from a genlight object \{adegenet\} and from it generates a population recode
table used to amalgamate populations with distance less than or equal to a specified t. The script then repeats the process
until there is no further amalgamation of populations.
The distance matricies are generated by gl.fixed.diff(), a recode table is generated using gl.collapse() and the resultant
recode table is applied to the genlight object using gl.pop.recode(). The process is repeated as many times as necessary to
yield a final table with no distances less than or equal to the specified threshold. The intermediate and final recode tables and distance matricies are
stored to disk as csv files for use with other analyses. In particular, the recode tables can be editted to replace Group1, Group2 etc with meaninful names.
}
\examples{
#only used the first 20 individuals due to runtime reasons
fd <- gl.collapse.recursive(testset.gl[1:20,], prefix="testset",threshold=0.026)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
