% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.r
\name{gl.dist}
\alias{gl.dist}
\title{Calculate a distance matrix for populations defined in an \{adegenet\} genlight object}
\usage{
gl.dist(gl, method = "euclidean", binary = FALSE, diag = TRUE,
  upper = FALSE, p = NULL)
}
\arguments{
\item{gl}{-- name of the genlight containing the SNP genotypes [required]}

\item{method}{-- Specify distance measure [method=euclidean]}

\item{binary}{-- Perform presence/absence standardization before analysis using decostand [binary=FALSE]}

\item{diag}{-- Compute and display diagonal}

\item{upper}{-- Return also upper triangle}

\item{p}{-- The power of the Minkowski distance}
}
\value{
A matrix of distances between populations (class dist)
}
\description{
This script calculates various distances between populations based on allele frequencies.
}
\details{
The distance measure can be one of "manhattan", "euclidean", "canberra", "bray", 
"kulczynski", "jaccard", "gower", "altGower", "morisita", "horn", "mountford", "raup" , 
"binomial", "chao", "cao", "mahalanobis", "maximum", "binary" or "minkowski". Refer to the documentation for
dist stats or vegdist vegan for definitions.
}
\examples{
gl.dist(testset.gl, method="gower", diag=TRUE)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
