% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_list.R
\name{as.Node.list}
\alias{FromListExplicit}
\alias{FromListSimple}
\alias{as.Node.list}
\title{Convert a nested \code{list} structure to a \code{data.tree} structure}
\usage{
\method{as.Node}{list}(x, mode = c("simple", "explicit"), nameName = "name",
  childrenName = "children", nodeName = NULL, ...)

FromListExplicit(explicitList, nameName = "name", childrenName = "children",
  nodeName = NULL)

FromListSimple(simpleList, nameName = "name", nodeName = NULL)
}
\arguments{
\item{x}{The \code{list} to be converted.}

\item{mode}{How the list is structured. "simple" (the default) will interpret any list to be a child. "explicit" 
assumes that children are in a nested list called \code{childrenName}}

\item{nameName}{The name of the element in the list that should be used as the name, can be NULL if the children lists are named}

\item{childrenName}{The name of the element that contains the child list (applies to mode 'explicit' only).}

\item{nodeName}{The name x will get (only applies if no nameName is available, this is useful for some conversions where th
name is not given explicitly)}

\item{...}{Any other argument to be passed to generic sub implementations}

\item{explicitList}{A \code{list} in which children are in a separate nested list called \code{childrenName}.}

\item{simpleList}{A \code{list} in which children are stored as nested list alongside other fields. Any list is
interpreted as a child \code{Node}}
}
\description{
Convert a nested \code{list} structure to a \code{data.tree} structure
}
\examples{
kingJosephs <- list(name = "Joseph I",
                    spouse = "Mary",
                    born = "1818-02-23",
                    died = "1839-08-29",
                    children = list(
                                    list(name = "Joseph II",
                                         spouse = "Kathryn",
                                         born = "1839-03-28",
                                         died = "1865-12-19"),
                                    list(name = "Helen",
                                         born = "1840-17-08",
                                         died = "1845-01-01")
                                    )
                   )
FromListExplicit(kingJosephs)

kingJosephs <- list(head = "Joseph I",
                    spouse = "Mary",
                    born = "1818-02-23",
                    died = "1839-08-29",
                    list(head = "Joseph II",
                         spouse = "Kathryn",
                         born = "1839-03-28",
                         died = "1865-12-19"),
                    list(head = "Helen",
                         born = "1840-17-08",
                         died = "1845-01-01")       
                   )
FromListSimple(kingJosephs, nameName = "head")

kingJosephs <- list(spouse = "Mary",
                    born = "1818-02-23",
                    died = "1839-08-29",
                    `Joseph II` = list(spouse = "Kathryn",
                                       born = "1839-03-28",
                                       died = "1865-12-19"),
                    Helen = list(born = "1840-17-08",
                                 died = "1845-01-01")
                                 
                   )
FromListSimple(kingJosephs, nodeName = "Joseph I")
  

}
\seealso{
Other as.Node: \code{\link{as.Node.data.frame}},
  \code{\link{as.Node.dendrogram}},
  \code{\link{as.Node.phylo}}, \code{\link{as.Node}}
}

