% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyMissing.R
\name{identifyMissing}
\alias{identifyMissing}
\title{A checkFunction for identifying miscoded missing values.}
\usage{
identifyMissing(v, nMax = Inf, ...)
}
\arguments{
\item{v}{A variable to check.}

\item{nMax}{The maximum number of problematic values to report. Default is \code{Inf}, in which case
all problematic values are included in the outputted message.}

\item{...}{Not in use.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether midcoded missing values where found),
\code{$message} (a message describing which values in \code{v} were suspected to be
miscoded missing values), and \code{$problemValues} (the problematic values
in their original format). Note that Only unique problematic values
are listed and that they are presented in alphabetical order.
}
\description{
A checkFunction to be called from \code{\link{check}} that identifies values that
appear to be miscoded missing values.
}
\details{
\code{identifyMissing} tries to identify common choices of missing values outside of the
R standard (\code{NA}). These include special words (NaN and Inf (no matter the cases)),
one or more -9/9's (e.g. 999, "99", -9, "-99"), one ore more -8/8's (e.g. -8, 888, -8888),
Stata style missing values (commencing with ".") and other character strings
("", " ", "-", "NA" miscoded as character). If the variable is numeric/integer or a
character/factor variable consisting only of numbers and with more than 11 different values,
the numeric miscoded missing values (999, 888, -99, -8 etc.) are
only recognized as miscoded missing if they are maximum or minimum, respectively, and the distance
between the second largest/smallest value and this maximum/minimum value is greater than one.
}
\examples{
##data(testData)
##testData$miscodedMissingVar
##identifyMissing(testData$miscodedMissingVar)

#Identify miscoded numeric missing values
v1 <- c(1:15, 99)
v2 <- c(v1, 98)
v3 <- c(-999, v2, 9999)
identifyMissing(v1)
identifyMissing(v2)
identifyMissing(v3)
identifyMissing(factor(v3))

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
