% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whichFunctions.R
\name{whichAreBijection}
\alias{whichAreBijection}
\title{Identify bijections}
\usage{
whichAreBijection(dataSet, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{verbose}{Should the algorithm talk (logical, default to TRUE)}
}
\value{
A list of index of columns that have an exact bijection in the dataSet set.
}
\description{
Find all the columns that are bijections of another column
}
\details{
Bijection, meaning that there is another column containing the exact same information (but maybe
 coded differently) for example col1: Men/Women, col2 M/W. \cr
This function is performing search by looking to every couple of columns. 
It computes numbers of unique elements in each columns, and number of unique tuples of values. \cr
Computation is made by exponential search, so that the function is faster. \cr
If \code{verbose} is TRUE, the column logged will be the one returned. \cr
Ex: if column i and column j (with j > i) are bijections it will return j, expect if j is a 
character then it return i.
}
\examples{
# First let's get a data set
data("adult")

# Now let's check which columns are equals
whichAreInDouble(adult)
# It doesn't give any result.

# Lets look of bijections
whichAreBijection(adult)
# Return education_num and education which contain the same info
}
