% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_factor.R
\name{generate_from_factor}
\alias{generate_from_factor}
\title{Recode factor}
\usage{
generate_from_factor(
  data_set,
  cols = "auto",
  verbose = TRUE,
  drop = FALSE,
  ...
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{list of character column(s) name(s) of data_set to transform. To transform all
factors, set it to "auto". (character, default to "auto")}

\item{verbose}{Should the function log (logical, default to TRUE)}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\value{
\code{data_set} with new columns. \code{data_set} is edited by \strong{reference}.
}
\description{
Recode factors into 3 new columns:
\itemize{
\item was the value not NA, "NA", "",
\item how often this value occures,
\item the order of the value (ex: M/F => 2/1 because F comes before M in alphabet).
}
}
\examples{
# Load data set
data(messy_adult)

# transform column "type_employer"
messy_adult <- generate_from_factor(messy_adult, cols = "type_employer")
head(messy_adult)

# To transform all factor columns:
messy_adult <- generate_from_factor(messy_adult, cols = "auto")
}
