% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getWQPSample}
\alias{getWQPSample}
\title{Import Sample Data for WRTDS}
\usage{
getWQPSample(siteNumber, characteristicName, startDate, endDate,
  interactive = TRUE)
}
\arguments{
\item{siteNumber}{string site number.  If USGS, it should be in the form :'USGS-XXXXXXXXX...'}

\item{characteristicName}{string}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
Sample dataframe
}
\description{
Imports data from the Water Quality Portal, so it could be STORET, NWIS, or . This function gets the data from: \url{http://www.waterqualitydata.us}
For raw data, use getWQPData.  This function will retrieve the raw data, and compress it (summing constituents). See
chapter 7 of the EGRET user guide for more details, then converts it to the Sample dataframe structure.
}
\examples{
# These examples require an internet connection to run
\dontrun{
Sample_01075 <- getWQPSample('USGS-01594440','Chloride', '', '')
Sample_All <- getWQPSample('WIDNR_WQX-10032762','Specific conductance', '', '')
}
}
\seealso{
\code{\link{getWQPData}}, \code{\link{getWQPSites}},
\code{\link{getWQPqwData}}, \code{\link{getNWISqwData}}, and \code{\link{readWQPData}},
\code{\link{compressData}}, \code{\link{populateSampleColumns}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

