% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citations.R
\name{create_WQP_bib}
\alias{create_WQP_bib}
\title{Create WQP data citation}
\usage{
create_WQP_bib(x)
}
\arguments{
\item{x}{Any data returned from an NWIS function, must
include "queryTime" and "url" attributes, which should
come with the data by default.}
}
\value{
bibentry object to use for citing the data.
}
\description{
Uses attributes from the WQP functions to create data citations.
}
\details{
See \code{?bibentry} for more information.
}
\examples{
\donttest{
WQPData <- readWQPqw("USGS-05288705",
                     parameterCd = "00300")
wqp_citation <- create_WQP_bib(WQPData)
wqp_citation

print(wqp_citation, style = "Bibtex")
print(wqp_citation, style = "citation")
}
}
