% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-data2.R
\name{check_data2}
\alias{check_data2}
\title{Check Data2}
\usage{
check_data2(data, values = NULL, min_row = 1, max_row = max_nrow(),
  key = character(0), data_name = substitute(data))
}
\arguments{
\item{data}{The data frame to check.}

\item{values}{A named list specifying the columns and
their associated classes and values.}

\item{min_row}{A count of the minimum number of rows.}

\item{max_row}{A count of the maximum number of rows.}

\item{key}{A character vector of the column names representing the key.}

\item{data_name}{A string of the name of data.}
}
\value{
Throws an informative error or returns an invisible copy of
data.
}
\description{
Checks a data frame's rows, columns, classes and values and key.
}
\details{
\code{check_data2} enforces some constraints.
By default it requires data to have rows (and therefore columns).
It also does not allow NULLs in values and
requires column names in values to be unique.
However it does not require that data only includes the columns in value.

For stricter data checking see \code{\link{check_data3}}.
}
