% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{search_by_theme}
\alias{search_by_theme}
\title{Creates a data.frame containing datasets from datos.gob.es}
\usage{
search_by_theme(theme, numentry = 50, page = 0)
}
\arguments{
\item{theme}{Theme to search}

\item{numentry}{Number of results for page}

\item{page}{The number of page to see, the first page is 0}
}
\value{
A data.frame
}
\description{
Send a request to datos.gob.es using the theme param
to search datasets that match with the theme, then the results are returned
as data.frame
}
\examples{
library(dataesgobr)
\donttest{
datasetsPublic <- search_by_theme('sector-publico', 20)
datasetsSalud <- search_by_theme('salud', page = 2)
}
}
