% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degeneracy_check.R
\name{find_wildcards}
\alias{find_wildcards}
\title{Find Indices for Non-identifiable Elements of State Matrix.}
\usage{
find_wildcards(state_mat, action_vec, cols)
}
\arguments{
\item{state_mat}{Numeric matrix with rows as states and columns as
predictors.}

\item{action_vec}{Numeric vector indicating what action to take for each
state.}

\item{cols}{Numeric vector same length as number of columns of the
state matrix\cr
(\code{state_mat}) 
with the action that each column of the
state matrix corresponds to the decision model taking in the previous
period. This is only relevant when the predictor variables of the FSM are
lagged outcomes that include the previous actions taken by that decision
model.}
}
\value{
Returns a list of indices (tuples specifying row and column of a
  matrix).
}
\description{
\code{find_wildcards} finds indices for non-identifiable elements of state
matrix.
}
\details{
This is a helper function for \code{\link{degeneracy_check}}.
}
\examples{
tft_state <- matrix(c(1, 1, 1, 1, 2, 2, 2, 2), 2, 4)
tft_action <- matrix(c(1, 2))
find_wildcards(tft_state, tft_action,  c(1, 2, 1, 2))

}
