% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamaps.R
\name{datamaps-shiny}
\alias{datamaps-shiny}
\alias{datamapsOutput}
\alias{renderDatamaps}
\alias{datamapsProxy}
\title{Shiny bindings for datamaps}
\usage{
datamapsOutput(outputId, width = "100\%", height = "400px")

renderDatamaps(expr, env = parent.frame(), quoted = FALSE)

datamapsProxy(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a datamaps}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{id}{id of map.}

\item{session}{shiny session.}
}
\description{
Output and render functions for using datamaps within Shiny
applications and interactive Rmd documents.
}
