% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-fishgrowth.r
\docType{data}
\name{fishgrowth}
\alias{fishgrowth}
\title{Fish growth variables.}
\format{
Contains three variables, as follows:
\describe{
\item{years}{Year at capture.}
\item{length}{Length at capture (mm).}
\item{scale}{radius of a key scale (mm).}
}
}
\source{
The data were obtained from the \eqn{alr4} library of R, specifically
from the dataframe \eqn{wblake} that includes only fish of ages 8 or younger.
}
\usage{
data(fishgrowth)
}
\description{
Variables of small mouth bass (i.e, a fish) collected in West Bearskin Lake,
Minnesota, in 1991.
}
\examples{
data(fishgrowth)    
head(fishgrowth) 
plot(length~age, data=fishgrowth) 
}
\references{
Weisberg S. 2014. Applied Linear Regression. 4th edition. Hoboken NJ: Wiley
}
\keyword{datasets}
