% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{getDataObject}
\alias{getDataObject}
\alias{getDataObject,D1Client-method}
\title{Download a data object from the DataONE Federation as a DataObject.}
\usage{
getDataObject(x, identifier, ...)

\S4method{getDataObject}{D1Client}(x, identifier)
}
\arguments{
\item{x}{A D1Client object.}

\item{identifier}{The identifier of the object to get.}

\item{...}{(not yet used)}
}
\value{
A DataObject or NULL if the object was not found in DataONE
}
\description{
A convenience method to download a data object and its associated SystemMetadata, wrapped
in a DataObject class.
}
\details{
This method performs multiple underlying calls to the DataONE repository network. 
CN.resolve() is called to locate the object on one or more repositories, and then each of these
is accessed until success at downloading the associated SystemMetadata and data bytes, which are 
finally wrapped in a DataObject and returned. Replaces previous getD1Object() method in the version 1
dataone library.
}
\examples{
\dontrun{
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
obj <- getDataObject(d1c, pid)
data <- getData(obj)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}

