% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\name{getDataPackage}
\alias{getDataPackage}
\alias{getDataPackage,D1Client-method}
\title{Download data from the DataONE Federation as a DataPackage.}
\usage{
getDataPackage(x, identifier, ...)

\S4method{getDataPackage}{D1Client}(x, identifier, lazyLoad = FALSE, limit = "1MB", quiet = TRUE)
}
\arguments{
\item{x}{A D1Client object.}

\item{identifier}{The identifier of a package, package metadata or other package member}

\item{...}{(not yet used)}

\item{lazyLoad}{A \code{logical} value. If TRUE, then only package member system metadata is downloaded and not data. 
The default is \code{FALSE}.}

\item{limit}{A \code{character} value specifying maximum package member size to download. Specified with "KB", "MB" or "TB"
for example: "100KB", "10MB", "20GB", "1TB". The default is "1MB".}

\item{quiet}{A \code{'logical'}. If TRUE (the default) then informational messages will not be printed.}
}
\value{
A DataPackage or NULL if the package was not found in DataONE
}
\description{
This is convenience method that will download all the members in a DataONE data package 
and insert them into a DataPackage, including associated SystemMetadata for each package
member.
}
\details{
A 'data package' that resides on a DataONE member node is defined as a collection of
digital objects that are described by a metadata document. The
}
\examples{
\dontrun{
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
pkg <- getDataPackage(d1c, pid)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}
