/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.dataone.client.RestClient;
import org.dataone.client.auth.CertificateManager;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.AuthenticationTimeout;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedMetadataType;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.Session;
import org.dataone.service.util.ExceptionHandler;

public class D1RestClient {
    protected static Log log = LogFactory.getLog(D1RestClient.class);
    protected RestClient rc;

    public D1RestClient() {
        this.rc = new RestClient();
        this.setupSSL(null);
    }

    public D1RestClient(AbstractHttpClient httpClient) {
        this.rc = new RestClient(httpClient);
        this.setupSSL(null);
    }

    public D1RestClient(Session session) {
        this.rc = new RestClient();
        this.setupSSL(session);
    }

    public D1RestClient(AbstractHttpClient httpClient, Session session) {
        this.rc = new RestClient(httpClient);
        this.setupSSL(session);
    }

    public HttpClient getHttpClient() {
        return this.rc.getHttpClient();
    }

    public String getLatestRequestUrl() {
        return this.rc.getLatestRequestUrl();
    }

    public void closeIdleConnections() {
        this.getHttpClient().getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
    }

    public void setTimeouts(int milliseconds) {
        this.rc.setTimeouts(milliseconds);
    }

    public void setupSSL(Session session) {
        SSLSocketFactory socketFactory = null;
        try {
            String subjectString = null;
            if (session != null && session.getSubject() != null) {
                subjectString = session.getSubject().getValue();
            }
            socketFactory = CertificateManager.getInstance().getSSLSocketFactory(subjectString);
        }
        catch (Exception e) {
            log.warn((Object)("Exception from CertificateManager at SSL setup - client will be anonymous: " + e.getClass() + ":: " + e.getMessage()));
        }
        try {
            Scheme sch = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
            this.rc.getHttpClient().getConnectionManager().getSchemeRegistry().register(sch);
        }
        catch (Exception e) {
            log.error((Object)("Failed to set up SSL connection for client. Continuing. " + e.getClass() + ":: " + e.getMessage()), (Throwable)e);
        }
    }

    public InputStream doGetRequest(String url) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        return this.doGetRequest(url, false);
    }

    public InputStream doGetRequest(String url, boolean allowRedirect) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrors((HttpResponse)this.rc.doGetRequest(url), (boolean)allowRedirect);
    }

    public Header[] doGetRequestForHeaders(String url) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrorsHeader((HttpResponse)this.rc.doGetRequest(url), (String)"GET");
    }

    public InputStream doDeleteRequest(String url) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrors((HttpResponse)this.rc.doDeleteRequest(url));
    }

    public Header[] doHeadRequest(String url) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrorsHeader((HttpResponse)this.rc.doHeadRequest(url), (String)"HEAD");
    }

    public InputStream doPutRequest(String url, SimpleMultipartEntity entity) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrors((HttpResponse)this.rc.doPutRequest(url, entity));
    }

    public InputStream doPostRequest(String url, SimpleMultipartEntity entity) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, SynchronizationFailed, UnsupportedMetadataType, UnsupportedType, IllegalStateException, ClientProtocolException, IOException, HttpException, VersionMismatch {
        this.rc.setHeader("Accept", "text/xml");
        return ExceptionHandler.filterErrors((HttpResponse)this.rc.doPostRequest(url, entity));
    }

    public void setHeader(String name, String value) {
        this.rc.setHeader(name, value);
    }

    public HashMap<String, String> getAddedHeaders() {
        return this.rc.getAddedHeaders();
    }
}

