/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.examples;

import java.io.StringBufferInputStream;
import java.math.BigInteger;
import org.dataone.client.D1Client;
import org.dataone.client.MNode;
import org.dataone.client.auth.ClientIdentityManager;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;

public class ExampleClient {
    public static void main(String[] args) {
        String currentUrl = "https://demo1.test.dataone.org:443/knb/d1/mn";
        MNode mn = D1Client.getMN(currentUrl);
        ExampleClient.runExampleCreate(mn);
    }

    private static void runExampleCreate(MNode mn) {
        try {
            Identifier newid = new Identifier();
            String idstr = new String("test:" + System.currentTimeMillis());
            newid.setValue(idstr);
            String csv = "1,2,3";
            StringBufferInputStream is = new StringBufferInputStream(csv);
            SystemMetadata sm = ExampleClient.generateSystemMetadata(newid);
            Identifier pid = mn.create(null, newid, is, sm);
            System.out.println("Create completed with PID: " + pid.getValue());
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    private static SystemMetadata generateSystemMetadata(Identifier newid) {
        SystemMetadata sm = new SystemMetadata();
        sm.setIdentifier(newid);
        ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
        fmtid.setValue("text/csv");
        sm.setFormatId(fmtid);
        sm.setSize(new BigInteger("5"));
        Checksum cs = new Checksum();
        cs.setAlgorithm("SHA-1");
        cs.setValue("879384579485739487534987");
        sm.setChecksum(cs);
        Subject clientSubject = ClientIdentityManager.getCurrentIdentity();
        sm.setRightsHolder(clientSubject);
        sm.setSubmitter(clientSubject);
        return sm;
    }
}

