/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.math.BigInteger;
import org.jibx.runtime.JiBXException;

public class BigIntegerMarshaller {
    static final BigInteger minLimit = new BigInteger("0");
    static final BigInteger maxLimit = new BigInteger("18446744073709551615");

    public static String serializeBigInteger(BigInteger bigInt) throws JiBXException {
        if (bigInt.compareTo(minLimit) >= 0 && bigInt.compareTo(maxLimit) <= 0) {
            return bigInt.toString();
        }
        throw new JiBXException("unsignedLong must be greater than or equal to 0 and less than or equal to 18446744073709551615");
    }

    public static BigInteger deserializeBigInteger(String bigIntValue) throws JiBXException {
        if (bigIntValue == null) {
            throw new JiBXException("serialized value cannot be null");
        }
        BigInteger bigInt = new BigInteger(bigIntValue);
        if (bigInt.compareTo(minLimit) >= 0 && bigInt.compareTo(maxLimit) <= 0) {
            return bigInt;
        }
        throw new JiBXException("unsignedLong must be greater than or equal to 0 and less than or equal to 18446744073709551615");
    }
}

