% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_is_integer.R
\name{util_is_integer}
\alias{util_is_integer}
\title{Check for integer values}
\usage{
util_is_integer(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{the object to test}

\item{tol}{precision of the detection. Values deviating more than \code{tol} from
their closest integer value will not be deemed integer.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
This function checks if a variable is integer.
}
\seealso{
is.integer

Copied from the documentation of \link[base]{is.integer}

\link[base]{is.integer} detects, if the storage mode of an R-object is
integer. Usually, users want to know, if the values are integer. As suggested
by \link[base]{is.integer}'s documentation, \code{is.wholenumber} does so.

Other robustness_functions: 
\code{\link{util_as_valid_missing_codes}()},
\code{\link{util_check_one_unique_value}()},
\code{\link{util_correct_variable_use}()},
\code{\link{util_empty}()},
\code{\link{util_ensure_character}()},
\code{\link{util_ensure_in}()},
\code{\link{util_ensure_suggested}()},
\code{\link{util_expect_scalar}()},
\code{\link{util_fix_rstudio_bugs}()},
\code{\link{util_is_numeric_in}()},
\code{\link{util_is_valid_missing_codes}()},
\code{\link{util_match_arg}()},
\code{\link{util_observations_in_subgroups}()},
\code{\link{util_stop_if_not}()},
\code{\link{util_warn_unordered}()}
}
\concept{data_management}
\concept{robustness_functions}
\keyword{internal}
