% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{internal_consistency}
\alias{internal_consistency}
\title{Daily internal consistency test}
\usage{
internal_consistency(dailydata, meta = NULL, outpath)
}
\arguments{
\item{dailydata}{A character vector giving the paths of two input files,
or a 5-column matrix with following columns: variable code, year, month,
day, and the daily value.}

\item{meta}{A data frame with 2 rows and 6 columns: station ID, latitude, 
longitude, altitude, variable code, units. If \code{dailydata} is a vector, 
\code{meta} is ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Determines the coherence between daily maximum temperature (Tx) values and
daily minimum temperature (Tn) values; daily wind speed (w) and wind
direction (dd); daily snow cover (sc) and snow depth (sd); daily fresh snow 
(fs) and snow depth (sd); daily fresh snow (fs) and minimum temperature (Tn);
daily snow depth (sd) and minimum temperature (Tn).
}
\details{
The input file must follow the Copernicus Station Exchange 
Format (SEF).

The daily minimum temperature is assumed to be observed at the same time of 
the snow depth / fresh snow, and to refer to the same 24-hour period. Snow 
accumulation is flagged if the minimum temperature is
higher than 3 degrees Celsius.
}
\examples{
internal_consistency(rbind(Rosario$Tx, Rosario$Tn), 
                     rbind(Meta$Tx, Meta$Tn),
                     outpath = tempdir())

}
\author{
Alba Gilabert, Yuri Brugnara
}
