% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingPredictions.R
\name{GetTrainingPredictions}
\alias{GetTrainingPredictions}
\title{Retrieve training predictions on a specified data set.}
\usage{
GetTrainingPredictions(project, predictionId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictionId}{character. ID of the prediction to retrieve training
predictions for.}
}
\description{
Retrieve training predictions on a specified data set.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  predictions <- ListTrainingPredictions(projectId)
  predictionId <- predictions[[1]]$id
  trainingPredictions <- GetTrainingPredictions(projectId, predictionId)
}
}
