% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{predict.dataRobotModel}
\alias{predict.dataRobotModel}
\title{Retrieve model predictions using R's default S3 \code{predict} method.}
\usage{
\method{predict}{dataRobotModel}(object, ...)
}
\arguments{
\item{object}{dataRobotModel. The object of class \code{dataRobotModel} to predict with.}

\item{...}{list. Additional arguments to pass to \code{Predict}}
}
\description{
Retrieve model predictions using R's default S3 \code{predict} method.
}
\examples{
\dontrun{
   trainIndex <- sample(nrow(iris) * 0.7)
   trainIris <- iris[trainIndex, ]
   testIris <- iris[-trainIndex, ]
   project <- StartProject(trainIris, "iris", target = "Petal_Width", wait = TRUE)
   model <- GetRecommendedModel(project)
   predictions <- predict(model, testIris)
}
}
\seealso{
Predict
}
