% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParetoFront.R
\name{AddEureqaSolution}
\alias{AddEureqaSolution}
\title{Add a Eureqa solution to the list of models for the project.}
\usage{
AddEureqaSolution(project, eureqaSolutionId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{eureqaSolutionId}{character. The solution ID of the Eureqa model to add.}
}
\description{
Each Eureqa model contains multiple possible solutions (see \code{GetParetoFront}).
However, only the best model is included in the leaderboard by default. To include
other models, you can get them via \code{GetParetoFront} and then add them.
}
\examples{
\dontrun{
  projectId <- "5b2827556523cd05bd1507a5"
  modelId <- "5b29406c6523cd0665685a8d"
  eureqaModel <- GetModel(projectId, modelId)
  paretoFront <- GetParetoFront(eureqModel)
}
}
