% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferableModels.R
\name{UploadTransferableModel}
\alias{UploadTransferableModel}
\title{Import a previously exported model for predictions.}
\usage{
UploadTransferableModel(modelFile, maxWait = 600)
}
\arguments{
\item{modelFile}{character. Path to binary transferable model file.}

\item{maxWait}{integer. Specifies how many seconds to wait for upload to finish.}
}
\value{
A list describing uploaded transferable model
with the following components:
\itemize{
  \item note. Character string Manually added node about this imported model.
  \item datasetName. Character string Filename of the dataset used to create the project the
    model belonged to.
  \item modelName. Character string Model type describing the model generated by DataRobot.
  \item displayName. Character string Manually specified human-readable name of the imported
    model.
  \item target. Character string The target of the project the model belonged to prior to export.
  \item projectName. Character string Name of the project the model belonged to prior to export.
  \item importedByUsername. Character string Username of the user who imported the model.
  \item importedAt. Character string The time the model was imported.
  \item version. Numeric Project version of the project the model belonged to.
  \item projectId. Character id of the project the model belonged to prior to export.
  \item featurelistName. Character string Name of the featurelist used to train the model.
  \item createdByUsername. Character string Username of the user who created the model prior to
    export.
  \item importedById. Character string id of the user who imported the model.
  \item id. Character string id of the import.
  \item createdById. Character string id of the user who created the model prior to export.
  \item modelId. Character string original id of the model prior to export.
  \item originUrl. Character string URL.
}
}
\description{
Import a previously exported model for predictions.
}
\examples{
\dontrun{
  UploadTransferableModel("model.drmodel")
}
}
\seealso{
Other Transferable Model functions: 
\code{\link{DeleteTransferableModel}()},
\code{\link{DownloadTransferableModel}()},
\code{\link{GetTransferableModel}()},
\code{\link{ListTransferableModels}()},
\code{\link{RequestTransferableModel}()},
\code{\link{UpdateTransferableModel}()}
}
\concept{Transferable Model functions}
