% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectToDataRobot.R
\name{ConnectToDataRobot}
\alias{ConnectToDataRobot}
\title{Establish a connection to the DataRobot modeling engine}
\usage{
ConnectToDataRobot(endpoint = NULL, token = NULL, username = NULL,
  password = NULL, configPath = NULL, url = NULL)
}
\arguments{
\item{endpoint}{URL specifying the DataRobot server to be used}

\item{token}{DataRobot API access token}

\item{username}{(no longer supported)}

\item{password}{(no longer supported)}

\item{configPath}{Path to YAML config file specifying configuration
(token and endpoint)}

\item{url}{(same as endpoint, deprecated)}
}
\description{
This function initializes a DataRobot session. If a (YAML) config file (with keys for endpoint
and token) is placed at $HOME/.config/datarobot/drconfig.yaml, then we
attempt to establish a connection to DataRobot when the package loads, so
(if successful) this function does not need to be called.
}
\details{
The function creates the environment variables "DataRobot_URL" and "DataRobot_Token" used by
other functions to access the DataRobot modeling engine.
}

