% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{GetPredictions}
\alias{GetPredictions}
\title{Retrieve model predictions from predictJobId}
\usage{
GetPredictions(project, predictJobId, type = "response", maxWait = 60)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{predictJobId}{Integer, identifying the prediction job
created by the call to RequestPredictions.}

\item{type}{Character string, specifying the type of response for
binary classifiers; see Details.}

\item{maxWait}{This process creates a project on the DataRobot server
asynchronously, and this function waits for that process to complete
before continuing. You can set the maximum wait time (in seconds) before
this function aborts.}
}
\value{
Vector of predictions, depending on the modeling task
("Binary" or "Regression") and the value of the type parameter;
see Details.
}
\description{
This function is called with a project descriptor and an
integer predictJobId, obtained from an earlier call to
RequestPredictions.  It returns the predictions generated
for the model and data specified in this prior function
call.
}
\details{
The contents of the return vector depends on both the modeling
task - binary classification or regression - and the value of
the type parameter.  For regression tasks, the type parameter
is ignored and a vector of numerical predictions of the response
variable is returned.  For binary classification tasks, either
a vector of predicted responses is returned if type has the
value "response" (the default), or a vector of probabilities
for the positive class is returned, if type is "probability".

This function will error if the requested job has errored, or
if it isn't complete within maxWait seconds.
}

