% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateUserPartition.R
\name{CreateUserPartition}
\alias{CreateUserPartition}
\title{Create a user-defined S3 object of class partition for the SetTarget function}
\usage{
CreateUserPartition(validationType, userPartitionCol, cvHoldoutLevel = NULL,
  trainingLevel = NULL, holdoutLevel = NULL, validationLevel = NULL)
}
\arguments{
\item{validationType}{Character string specifying the type of partition
generated, either 'TVH' or 'CV'.}

\item{userPartitionCol}{Character string naming the data column from the
modeling dataset containing the subset designations.}

\item{cvHoldoutLevel}{Data value from userPartitionCol that identifies the
holdout subset under the 'CV' option.}

\item{trainingLevel}{Data value from userPartitionCol that identifies the
training subset under the 'TVH' option.}

\item{holdoutLevel}{Data value from userPartitionCol that identifies the
holdout subset under the 'TVH' option.}

\item{validationLevel}{Data value from userPartitionCol that identifies the
validation subset under the 'TVH' option.}
}
\value{
An S3 object of class 'partition' including the parameters required
by the SetTarget function to generate a user-specified of the modeling
dataset.
}
\description{
Creates a list object used by the SetTarget function to specify either
Training/Validation/Holdout (validationType = 'TVH') or cross-validation
(validationType = 'CV') partitions of the modeling dataset based on the values
included in a column from the dataset. In either case, the name of this data
column must be specified (as userPartitionCol). For the 'TVH' option, the
column must have either exactly 3 values (in which case the values
used to specify each level must be given) or exactly 2 values (in which
case training and validation levels should be specified, but), while for the 'CV' option, only the
level that specifies the holdout subset must be given.
}
\details{
This function is one of several convenience functions provided to simplify the
task of starting modeling projects with custom partitioning options. The other
functions are CreateGroupPartition, CreateRandomPartition, and CreateStratifiedPartition.
}

