% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{RequestFrozenDatetimeModel}
\alias{RequestFrozenDatetimeModel}
\title{Train a new frozen datetime model with parameters from the specified model}
\usage{
RequestFrozenDatetimeModel(model, trainingRowCount = NULL,
  trainingDuration = NULL, trainingStartDate = NULL,
  trainingEndDate = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModelObject, or each element of the list returned by
the function GetAllModels.}

\item{trainingRowCount}{Integer (optional) the number of rows of data that
should be used to train the model.}

\item{trainingDuration}{Character string (optional) a duration string specifying what
time range the data used to train the model should span.}

\item{trainingStartDate}{Character string(optional) the start date of the data to train to model on 
("%Y-%m-%dT%H:%M:%SZ" RFC 3339 format).
Only rows occurring at or after this datetime will be used.}

\item{trainingEndDate}{Character string(optional) the end date of the data to train the model on 
("%Y-%m-%dT%H:%M:%SZ" RFC 3339 format).
Only rows occurring strictly before this datetime will be used.}
}
\value{
An integer value that can be used as the modelJobId parameter
in subsequent calls to the GetDatetimeModelFromJobId function.
}
\description{
Requires that this model belongs to a datetime partitioned project.  
 If it does not, an error will occur when submitting the job
}
\details{
Frozen models use the same tuning parameters as their parent model 
instead of independently optimizing them to allow efficiently 
retraining models on larger amounts of the training data.

In addition to trainingRowCount and trainingDuration, frozen datetime models 
may be trained on an exact date range.  Only one of trainingRowCount, 
trainingDuration, or trainingStartDate and trainingEndDate should be specified.
Models specified using trainingStartDate and trainingEndDate are the only ones 
that can be trained into the holdout data (once the holdout is unlocked).
}
