% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferrableModels.R
\name{UpdateTransferrableModel}
\alias{UpdateTransferrableModel}
\title{Update the display name or note for an imported model.}
\usage{
UpdateTransferrableModel(importId, displayName = NULL, note = NULL)
}
\arguments{
\item{importId}{Character string unique id of the import}

\item{displayName}{Character string The new display name}

\item{note}{Character string The new note}
}
\value{
A list describing uploaded transferrable model
with the following components:
\describe{
  \item{note}{Character string Manually added node about this imported model}
  \item{datasetName}{Character string Filename of the dataset used to create the project the model belonged to}
  \item{modelName}{Character string Model type describing the model generated by DataRobot}
  \item{displayName}{Character string Manually specified human-readable name of the imported model}
  \item{target}{Character string The target of the project the model belonged to prior to export}
  \item{projectName}{Character string Name of the project the model belonged to prior to export}
  \item{importedByUsername}{Character string Username of the user who imported the model}
  \item{importedAt}{Character string The time the model was imported}
  \item{version}{Numeric Project version of the project the model belonged to}
  \item{projectId}{Character id of the project the model belonged to prior to export}
  \item{featurelistName}{Character string Name of the featurelist used to train the model}
  \item{createdByUsername}{Character string Username of the user who created the model prior to export}
  \item{importedById}{Character string id of the user who imported the model}
  \item{id}{Character string id of the import}
  \item{createdById}{Character string id of the user who created the model prior to export}
  \item{modelId}{Character string original id of the model prior to export}
  \item{originUrl}{Character string URL}
}
}
\description{
Update the display name or note for an imported model.
}
