% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasaurus-package.R
\docType{data}
\name{datasaurus_dozen_wide}
\alias{datasaurus_dozen_wide}
\title{Datasaurus Dozen (wide) data}
\format{
A data frame with 142 rows and 26 variables:
\itemize{
\item \strong{away_x}: x-values for the \code{away} dataset
\item \strong{away_y}: y-values for the \code{away} dataset
\item \strong{bullseye_x}: x-values for the \code{bullseye} dataset
\item \strong{bullseye_y}: y-values for the \code{bullseye} dataset
\item \strong{circle_x}: x-values for the \code{circle} dataset
\item \strong{circle_y}: y-values for the \code{circle} dataset
\item \strong{dino_x}: x-values for \code{dinosaur} dataset!
\item \strong{dino_y}: y-values for \code{dinosaur} dataset!
\item \strong{dots_x}: x-values for the \code{dots} dataset
\item \strong{dots_y}: y-values for the \code{dots} dataset
\item \strong{h_lines_x}: x-values for the \code{h_lines} dataset
\item \strong{h_lines_y}: y-values for the \code{h_lines} dataset
\item \strong{high_lines_x}: x-values for the \code{high_lines} dataset
\item \strong{high_lines_y}: y-values for the \code{high_lines} dataset
\item \strong{slant_down_x}: x-values for the \code{slant_down} dataset
\item \strong{slant_down_y}: y-values for the \code{slant_down} dataset
\item \strong{slant_up_x}: x-values for the \code{slant_up} dataset
\item \strong{slant_up_y}: y-values for the \code{slant_up} dataset
\item \strong{star_x}: x-values for the \code{star} dataset
\item \strong{star_y}: y-values for the \code{star} dataset
\item \strong{v_lines_x}: x-values for the \code{v_lines} dataset
\item \strong{v_lines_y}: y-values for the \code{v_lines} dataset
\item \strong{wide_lines_x}: x-values for the \code{wide_lines} dataset
\item \strong{wide_lines_y}: y-values for the \code{wide_lines} dataset
\item \strong{x_shape_x}: x-values for the \code{x_shape} dataset
\item \strong{x_shape_y}: y-values for the \code{x_shape} dataset
}
}
\usage{
datasaurus_dozen_wide
}
\description{
A dataset demonstrating the utility of visualization.
These 12 datasets are equal in standard measures: mean,
standard deviation, and Pearson's correlation.
}
\examples{
# Save current settings
state = par("mar", "mfrow")

# Base R Plots
par(mfrow = c(5, 3), mar = c(1, 3, 3, 1))

nms = names(datasaurus_dozen_wide)
for (i in seq(1, 25, by = 2)) {
  nm = substr(nms[i], 1, nchar(nms[i]) - 2)
  plot(datasaurus_dozen_wide[[nms[i]]],
       datasaurus_dozen_wide[[nms[i + 1]]],
       xlab = "", ylab = "", main = nm)
}

#reset settings
par(state)
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.autodesk.com/research/publications/same-stats-different-graphs}. #nolint
}
\keyword{datasets}
