% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bibentry.R
\name{get_bibentry}
\alias{get_bibentry}
\alias{set_bibentry<-}
\title{Get/set the Bibentry of the object.}
\usage{
get_bibentry(dataset)

set_bibentry(dataset) <- value
}
\arguments{
\item{dataset}{A dataset created with \code{\link{dataset_df}}.}

\item{value}{A \code{\link[utils:bibentry]{utils::bibentry}} object, or a newly
initialised bibentry object with DataCite default values for unassigned entries.}
}
\value{
The \code{get_bibentry} returns from the \code{\link[utils]{bibentry}}
object of \code{x} from its attributes; the \code{`set_bibentry<-`} assignment
function sets this attribute to \code{value} and invisibly returns \code{x}
with the changed attributes. To set well-formatted input \code{value},
refer to \code{\link{datacite}} or
\code{\link{dublincore}} (see Details.)
}
\description{
The \code{\link{dataset_df}} objects contain among their attributes bibliographic entries which
are stored in a \code{\link[utils:bibentry]{utils::bibentry}} object.
Upon creation, these entries are filled with default values when applicable. \cr
\cr
To retrieve the bibentry of a dataset_df object, use \code{get_bibentry}.\cr
\cr
To create a new bibentry, use the \code{\link{datacite}} function for an interface and
default values according to the DataCite standard, or the
\code{\link{dublincore}} function for the more general Dublin Core standard.\cr
\cr
To change or an entire new bibliographic entry to a dataset_df object (or any
data.frame-like object), use the \code{`set_bibentry<-`} function (see examples.)
For more details, please check the \code{vignette("bibentry", package="dataset")}
vignette.
}
\examples{
# Get the bibentry of a dataset_df object:
iris_bibentry <- get_bibentry(iris_dataset)

# Create a well-formatted bibentry object:
alternative_bibentry <- datacite(
     Creator=person("Jane Doe"),
     Title ="The Famous Iris Dataset",
     Publisher = "MyOrg")

# Assign the new bibentry object:
set_bibentry(iris_dataset) <- alternative_bibentry

# Print the bibentry object according to the DataCite notation:
as_datacite(iris_dataset, "list")

# Print the bibentry object according to the Dublin Core notation:
as_dublincore(iris_dataset, "list")
}
\seealso{
Other bibentry functions: 
\code{\link{datacite}()},
\code{\link{dublincore}()}
}
\concept{bibentry functions}
