% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_namespace.R
\name{var_namespace}
\alias{var_namespace}
\alias{var_namespace<-}
\alias{get_variable_namespaces}
\alias{namespace_attribute}
\alias{get_namespace_attribute}
\alias{set_namespace_attribute}
\alias{namespace_attribute<-}
\title{Get / Set a namespace of measure}
\usage{
var_namespace(x, ...)

var_namespace(x) <- value

get_variable_namespaces(x, ...)

namespace_attribute(x)

get_namespace_attribute(x)

set_namespace_attribute(x, value)

namespace_attribute(x) <- value
}
\arguments{
\item{x}{a vector}

\item{...}{Further potential parameters reserved for inherited classes.}

\item{value}{a character string or \code{NULL} to remove the namespace of measure.}
}
\value{
The namespace attribute of a vector constructed with \code{\link{defined}}.
}
\description{
Retain the namespace part of a permanent, global variable identifier which
is independent of the R instance in use.
}
\details{
The namespace attribute is useful when users join or concatenate data from
remote, linked, and open data sources. In such cases, variable identifiers
(labels or names) are often resolved with a common namespace prefix, which,
together with the namespace, forms a URI or IRI permanent identifier for the
variable. Retaining the namespace in such cases allows cross-validation or
success later updates of the vector (as a column of a dataset.)

\code{get_variable_namespaces()} is identical to \code{var_namespace()}.
See \code{vignette("defined", package = "dataset")} to use comprehensively
with variable labels, namespaces, units of measures, and machine-independent
permanent variable identifiers.
}
\examples{
qid = defined(c("Q275912", "Q116196078"), namespace = "https://www.wikidata.org/wiki/")
var_namespace(qid)

# To remove a namespace
var_namespace(qid) <- NULL
}
\seealso{
Other defined metadata methods and functions: 
\code{\link{defined}()},
\code{\link{var_label}()},
\code{\link{var_unit}()}
}
\concept{defined metadata methods and functions}
