% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_decrease.R, R/ds_heap.R
\docType{methods}
\name{decrease_key}
\alias{decrease_key}
\alias{decrease_key,heap,vector,vector,character-method}
\alias{decrease_key,heap,vector,vector,missing-method}
\title{Decreases the key of a node in a heap}
\usage{
decrease_key(obj, from, to, handle)

\S4method{decrease_key}{heap,vector,vector,character}(obj, from, to, handle)

\S4method{decrease_key}{heap,vector,vector,missing}(obj, from, to)
}
\arguments{
\item{obj}{a heap object}

\item{from}{a key in the heap for which the node should be decreased}

\item{to}{the new value of the heap}

\item{handle}{the handle of the specific node that is decreases}
}
\value{
returns extracted handles and values from \code{obj}
}
\description{
Decreases the key of a node in a heap and updates the complete
 heap. The key is decreases \code{from} a value \code{to} a value by that moving the
 node's position in the heap. If a node cannot uniquely be identified using
 the \code{to} key, a \code{\link{handle}} needs to be given in addition.
}
