% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_map_bimap.R
\docType{class}
\name{bimap-class}
\alias{bimap-class}
\title{Bimap class}
\description{
Implementation of a bimap data structure, i.e. an unordered
collection of key-value pairs. The notable difference to
\code{\linkS4class{hashmap}} is that the mapping is not only
\deqn{f: keys -> values,}
but also
\deqn{f: values -> keys.}
Inserting and accessing is amortized in \emph{O(1)}.
\code{bimap} wraps a \code{boost::bimap} using Rcpp modules.
}
\section{Slots}{

\describe{
\item{\code{.map}}{\code{C++} object representing a mapping}

\item{\code{.key.class}}{the class of the keys}

\item{\code{.value.class}}{the class of the values}
}}

\seealso{
\code{\link{bimap}} for creating a new \code{bimap} object
}
