% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peek.R, R/ds_deque.R, R/ds_heap.R,
%   R/ds_map.R
\docType{methods}
\name{peek}
\alias{peek}
\alias{peek,deque-method}
\alias{peek,heap-method}
\alias{peek,map-method}
\title{Have a look at the first element from an object without removing it}
\usage{
peek(obj)

\S4method{peek}{deque}(obj)

\S4method{peek}{heap}(obj)

\S4method{peek}{map}(obj)
}
\arguments{
\item{obj}{the object to peek}
}
\value{
returns the first element from \code{obj} as list
}
\description{
Peeks into an object, i.e. takes the first element and returns
 it without removing it from the object. The data structure that has a peek
 method usually uses some sort of priority of its elements.
}
\examples{

 # peeks into a queue
 q <- queue()
 q <- insert(q, list(environment(), data.frame(a=1)))
 peek(q)

 # peeks into a fibonacci heap
 b_heap <- binomial_heap()
 b_heap <- insert(b_heap, letters[seq(3)], list(1, diag(3), rnorm(2)))
 peek(b_heap)

 # peeks into a \\code{hashmap}
 h_map <- hashmap()
 h_map[letters] <- rnorm(length(letters))
 peek(h_map)

 # peeks into a \\code{bimap}
 b_map <- bimap("integer", "integer")
 b_map[seq(10)] <- seq(10, 1)
 peek(b_map)

}
