% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_size.R, R/ds_deque.R, R/ds_heap.R,
%   R/ds_map.R
\docType{methods}
\name{size}
\alias{size}
\alias{size,deque-method}
\alias{size,heap-method}
\alias{size,map-method}
\title{Get the size of an object}
\usage{
size(obj)

\S4method{size}{deque}(obj)

\S4method{size}{heap}(obj)

\S4method{size}{map}(obj)
}
\arguments{
\item{obj}{the object to get the size from}
}
\value{
returns the size of \code{obj}
}
\description{
Computes the size of an object, i.e. the number of keys or
 <key, value> pairs depending on the object.
}
\examples{

 # get the size of a hashmap
 h_map <- hashmap()
 h_map[letters] <- rnorm(length(letters))
 size(h_map)

 # get the size of a fibonacci heap
 f_heap <- fibonacci_heap()
 f_heap <- insert(f_heap, letters[seq(3)], list(1, diag(3), rnorm(2)))
 size(f_heap)

 # get the size of a stack
 s <- stack()
 s <- insert(s, list(1))
 size(s)

}
