% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rotate.R
\name{data_rotate}
\alias{data_rotate}
\alias{data_transpose}
\title{Rotate a data frame}
\usage{
data_rotate(data, rownames = NULL, colnames = FALSE, verbose = TRUE)

data_transpose(data, rownames = NULL, colnames = FALSE, verbose = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{rownames}{Character vector (optional). If not \code{NULL}, the data frame's
rownames will be added as (first) column to the output, with \code{rownames}
being the name of this column.}

\item{colnames}{Logical or character vector (optional). If \code{TRUE}, the values
of the first column in \code{x} will be used as column names in the rotated data
frame. If a character vector, values from that column are used as column
names.}

\item{verbose}{Toggle warnings.}
}
\value{
A (rotated) data frame.
}
\description{
This function rotates a data frame, i.e. columns become rows and vice versa.
It's the equivalent of using \code{t()} but restores the \code{data.frame} class,
preserves attributes and prints a warning if the data type is
modified (see example).
}
\examples{
x <- mtcars[1:3, 1:4]

x

data_rotate(x)
data_rotate(x, rownames = "property")

# use values in 1. column as column name
data_rotate(x, colnames = TRUE)
data_rotate(x, rownames = "property", colnames = TRUE)

# warn that data types are changed
str(data_rotate(iris[1:4, ]))

# use either first column or specific column for column names
x <- data.frame(a = 1:5, b = 11:15, c = letters[1:5], d = rnorm(5))
data_rotate(x, colnames = TRUE)
data_rotate(x, colnames = "c")
}
