% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_reverse.R
\name{data_reverse}
\alias{data_reverse}
\alias{reverse_scale}
\alias{data_reverse.numeric}
\alias{data_reverse.data.frame}
\title{Reverse-Score Variables}
\usage{
data_reverse(x, ...)

reverse_scale(x, ...)

\method{data_reverse}{numeric}(x, range = NULL, verbose = TRUE, ...)

\method{data_reverse}{data.frame}(
  x,
  range = NULL,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  ...
)
}
\arguments{
\item{x}{A (grouped) data frame, numeric vector or factor.}

\item{...}{Arguments passed to or from other methods.}

\item{range}{Initial (old) range of values. If \code{NULL}, will take the range of
the input vector (\code{range(x)}).}

\item{verbose}{Toggle warnings.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}
}
\value{
A reverse-scored object.
}
\description{
Reverse-score variables (change the keying/scoring direction).
}
\examples{
data_reverse(c(1, 2, 3, 4, 5))
data_reverse(c(-2, -1, 0, 2, 1))

# Specify the "theoretical" range of the input vector
data_reverse(c(1, 3, 4), range = c(0, 4))

# Factor variables
data_reverse(factor(c(1, 2, 3, 4, 5)))
data_reverse(factor(c(1, 2, 3, 4, 5)), range = 0:10)

# Data frames
head(data_reverse(iris))
head(data_reverse(iris, select = "Sepal.Length"))

}
\seealso{
Other transform utilities: 
\code{\link{data_rescale}()},
\code{\link{normalize}()},
\code{\link{ranktransform}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
