% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_visualization.R
\name{plot_dynamic_network}
\alias{plot_dynamic_network}
\title{Plots a dynamic Bayesian network in a hierarchical way}
\usage{
plot_dynamic_network(structure, offset = 200)
}
\arguments{
\item{structure}{the structure or fit of the network.}

\item{offset}{the blank space between time slices}
}
\value{
the visualization of the DBN
}
\description{
To plot the DBN, this method first computes a hierarchical structure
for a time slice and replicates it for each slice. Then, it calculates the
relative position of each node with respect to his equivalent in the first
slice. The result is a net where each time slice is ordered and separated
from one another, where the leftmost slice is the oldest and the rightmost
represents the present time.
}
\examples{
\donttest{
size = 3
dt_train <- dbnR::motor[200:2500]
net <- learn_dbn_struc(dt_train, size)
plot_dynamic_network(net)
}
}
